"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
function create() {
    return {
        name: 'vue-document-links',
        capabilities: {
            documentLinkProvider: {},
        },
        create(context) {
            return {
                provideDocumentLinks(document) {
                    const decoded = context.decodeEmbeddedDocumentUri(vscode_uri_1.URI.parse(document.uri));
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (sourceScript?.generated?.root instanceof language_core_1.VueVirtualCode && virtualCode?.id === 'template') {
                        const result = [];
                        const codegen = language_core_1.tsCodegen.get(sourceScript.generated.root._sfc);
                        const scopedClasses = codegen?.generatedTemplate.get()?.scopedClasses ?? [];
                        const styleClasses = new Map();
                        const option = sourceScript.generated.root.vueCompilerOptions.experimentalResolveStyleCssClasses;
                        for (let i = 0; i < sourceScript.generated.root._sfc.styles.length; i++) {
                            const style = sourceScript.generated.root._sfc.styles[i];
                            if (option === 'always' || (option === 'scoped' && style.scoped)) {
                                for (const className of style.classNames) {
                                    if (!styleClasses.has(className.text.substring(1))) {
                                        styleClasses.set(className.text.substring(1), []);
                                    }
                                    styleClasses.get(className.text.substring(1)).push({
                                        index: i,
                                        style,
                                        classOffset: className.offset,
                                    });
                                }
                            }
                        }
                        for (const { className, offset } of scopedClasses) {
                            const styles = styleClasses.get(className);
                            if (styles) {
                                for (const style of styles) {
                                    const styleDocumentUri = context.encodeEmbeddedDocumentUri(decoded[0], 'style_' + style.index);
                                    const styleVirtualCode = sourceScript.generated.embeddedCodes.get('style_' + style.index);
                                    if (!styleVirtualCode) {
                                        continue;
                                    }
                                    const styleDocument = context.documents.get(styleDocumentUri, styleVirtualCode.languageId, styleVirtualCode.snapshot);
                                    const start = styleDocument.positionAt(style.classOffset);
                                    const end = styleDocument.positionAt(style.classOffset + className.length + 1);
                                    result.push({
                                        range: {
                                            start: document.positionAt(offset),
                                            end: document.positionAt(offset + className.length),
                                        },
                                        target: context.encodeEmbeddedDocumentUri(decoded[0], 'style_' + style.index) + `#L${start.line + 1},${start.character + 1}-L${end.line + 1},${end.character + 1}`,
                                    });
                                }
                            }
                        }
                        return result;
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-document-links.js.map