export interface IEffectScope extends Subscriber {
    nextNotify: IEffectScope | undefined;
    notify(): void;
}
export interface IEffect extends Dependency, IEffectScope {
}
export interface IComputed extends Dependency, Subscriber {
    update(): void;
}
export interface Dependency {
    subs: Link | undefined;
    subsTail: Link | undefined;
    linkedTrackId: number;
}
export interface Subscriber {
    trackId: number;
    canPropagate: boolean;
    dirtyLevel: DirtyLevels;
    deps: Link | undefined;
    depsTail: Link | undefined;
}
export interface Link {
    dep: Dependency | IComputed | IEffect;
    sub: IComputed | IEffect | IEffectScope;
    trackId: number;
    prevSub: Link | undefined;
    nextSub: Link | undefined;
    nextDep: Link | undefined;
}
export declare const enum DirtyLevels {
    None = 0,
    SideEffectsOnly = 1,
    MaybeDirty = 2,
    Dirty = 3,
    Released = 4
}
export declare namespace System {
    let activeSub: IComputed | IEffect | undefined;
    let activeEffectScope: IEffectScope | undefined;
    let activeTrackId: number;
    let activeEffectScopeTrackId: number;
    let batchDepth: number;
    let lastTrackId: number;
    let queuedEffects: IEffectScope | undefined;
    let queuedEffectsTail: IEffectScope | undefined;
}
export declare function startBatch(): void;
export declare function endBatch(): void;
export declare namespace Link {
    let pool: Link | undefined;
}
export declare namespace Dependency {
    function linkSubscriber(dep: Link['dep'], sub: Link['sub']): void;
    function propagate(subs: Link): void;
}
export declare namespace Subscriber {
    function runInnerEffects(link: Link | undefined): void;
    function resolveMaybeDirty(sub: IComputed | IEffect, depth?: number): void;
    function resolveMaybeDirtyNonRecursive(sub: IComputed | IEffect): void;
    function startTrackDependencies(sub: IComputed | IEffect): IEffect | IComputed | undefined;
    function endTrackDependencies(sub: IComputed | IEffect, prevSub: IComputed | IEffect | undefined): void;
    function clearTrack(link: Link): void;
    function startTrackEffects(sub: IEffectScope): IEffectScope | undefined;
    function endTrackEffects(sub: IEffectScope, prevSub: IEffectScope | undefined): void;
}
