// The Wasmer C/C++ header file compatible with the [`wasm-c-api`]
// standard API, as `wasm.h` (included here).
//
// This file is automatically generated by `lib/c-api/build.rs` of the
// [`wasmer-c-api`] Rust crate.
//
// # Stability
//
// The [`wasm-c-api`] standard API is a _living_ standard. There is no
// commitment for stability yet. We (Wasmer) will try our best to keep
// backward compatibility as much as possible. Nonetheless, some
// necessary API aren't yet standardized, and as such, we provide a
// custom API, e.g. `wasi_*` types and functions.
//
// The documentation makes it clear whether a function is unstable.
// 
// When a type or a function will be deprecated, it will be marked as
// such with the appropriated compiler warning, and will be removed at
// the next release round.
//
// # Documentation
//
// At the time of writing, the [`wasm-c-api`] standard has no
// documentation. This file also does not include inline
// documentation. However, we have made (and we continue to make) an
// important effort to document everything. [See the documentation
// online][documentation]. Please refer to this page for the real
// canonical documentation. It also contains numerous examples.
//
// To generate the documentation locally, run `cargo doc --open` from
// within the [`wasmer-c-api`] Rust crate.
//
// [`wasm-c-api`]: https://github.com/WebAssembly/wasm-c-api
// [`wasmer-c-api`]: https://github.com/wasmerio/wasmer/tree/main/lib/c-api
// [documentation]: https://wasmerio.github.io/wasmer/crates/wasmer_c_api/

#if !defined(WASMER_H_PRELUDE)

#define WASMER_H_PRELUDE

// Define the `ARCH_X86_X64` constant.
#if defined(MSVC) && defined(_M_AMD64)
#  define ARCH_X86_64
#elif (defined(GCC) || defined(__GNUC__) || defined(__clang__)) && defined(__x86_64__)
#  define ARCH_X86_64
#endif

// Compatibility with non-Clang compilers.
#if !defined(__has_attribute)
#  define __has_attribute(x) 0
#endif

// Compatibility with non-Clang compilers.
#if !defined(__has_declspec_attribute)
#  define __has_declspec_attribute(x) 0
#endif

// Define the `DEPRECATED` macro.
#if defined(GCC) || defined(__GNUC__) || __has_attribute(deprecated)
#  define DEPRECATED(message) __attribute__((deprecated(message)))
#elif defined(MSVC) || __has_declspec_attribute(deprecated)
#  define DEPRECATED(message) __declspec(deprecated(message))
#endif

// The `compiler` feature has been enabled for this build.
#define WASMER_UNIVERSAL_ENABLED

// The `compiler` feature has been enabled for this build.
#define WASMER_COMPILER_ENABLED

// The `wasi` feature has been enabled for this build.
#define WASMER_WASI_ENABLED

// The `middlewares` feature has been enabled for this build.
#define WASMER_MIDDLEWARES_ENABLED

// This file corresponds to the following Wasmer version.
#define WASMER_VERSION "5.0.2"
#define WASMER_VERSION_MAJOR 5
#define WASMER_VERSION_MINOR 0
#define WASMER_VERSION_PATCH 2
#define WASMER_VERSION_PRE ""

#endif // WASMER_H_PRELUDE


//
// OK, here we go. The code below is automatically generated.
//


#ifndef WASMER_H
#define WASMER_H

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include "wasm.h"

#if defined(WASMER_WASI_ENABLED)
typedef enum wasi_version_t {
#if defined(WASMER_WASI_ENABLED)
  INVALID_VERSION = -1,
#endif
#if defined(WASMER_WASI_ENABLED)
  LATEST = 0,
#endif
#if defined(WASMER_WASI_ENABLED)
  SNAPSHOT0 = 1,
#endif
#if defined(WASMER_WASI_ENABLED)
  SNAPSHOT1 = 2,
#endif
#if defined(WASMER_WASI_ENABLED)
  WASIX32V1 = 3,
#endif
#if defined(WASMER_WASI_ENABLED)
  WASIX64V1 = 4,
#endif
} wasi_version_t;
#endif

#if defined(WASMER_COMPILER_ENABLED)
typedef enum wasmer_compiler_t {
  CRANELIFT = 0,
  LLVM = 1,
  SINGLEPASS = 2,
} wasmer_compiler_t;
#endif

typedef enum wasmer_engine_t {
  UNIVERSAL = 0,
} wasmer_engine_t;

#if defined(WASMER_COMPILER_ENABLED)
typedef enum wasmer_parser_operator_t {
#if defined(WASMER_COMPILER_ENABLED)
  Unreachable,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Nop,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Block,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Loop,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  If,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Else,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Try,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Catch,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  CatchAll,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Delegate,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Throw,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Rethrow,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Unwind,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  End,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Br,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  BrIf,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  BrTable,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Return,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Call,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  CallIndirect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  ReturnCall,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  ReturnCallIndirect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Drop,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  Select,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TypedSelect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  LocalGet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  LocalSet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  LocalTee,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  GlobalGet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  GlobalSet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Load,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Load,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Load,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Load8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Load8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Load16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Load16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Load32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Store,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Store,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Store,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Store,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Store8,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Store16,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Store8,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Store16,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Store32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemorySize,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryGrow,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Const,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Const,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Const,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Const,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  RefNull,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  RefIsNull,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  RefFunc,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Eqz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32LtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32GtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32LeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32GeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Eqz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64LtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64GtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64LeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64GeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Lt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Gt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Le,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Ge,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Lt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Gt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Le,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Ge,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Clz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Ctz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Popcnt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32DivS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32DivU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32RemS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32RemU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32And,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Or,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Xor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Rotl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Rotr,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Clz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Ctz,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Popcnt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64DivS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64DivU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64RemS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64RemU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64And,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Or,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Xor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Rotl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Rotr,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Ceil,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Floor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Trunc,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Nearest,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Sqrt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Div,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Min,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Max,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32Copysign,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Ceil,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Floor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Trunc,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Nearest,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Sqrt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Div,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Min,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Max,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64Copysign,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32WrapI64,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncF32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncF32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncF64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncF64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64ExtendI32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64ExtendI32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncF32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncF32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncF64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncF64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32ConvertI32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32ConvertI32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32ConvertI64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32ConvertI64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32DemoteF64,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64ConvertI32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64ConvertI32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64ConvertI64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64ConvertI64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64PromoteF32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32ReinterpretF32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64ReinterpretF64,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32ReinterpretI32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64ReinterpretI64,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Extend8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32Extend16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Extend8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Extend16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64Extend32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncSatF32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncSatF32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncSatF64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32TruncSatF64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncSatF32S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncSatF32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncSatF64S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64TruncSatF64U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryInit,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  DataDrop,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryCopy,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryFill,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableInit,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  ElemDrop,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableCopy,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableFill,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableGet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableSet,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableGrow,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  TableSize,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryAtomicNotify,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryAtomicWait32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  MemoryAtomicWait64,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  AtomicFence,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicLoad,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicLoad,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicLoad8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicLoad16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicLoad8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicLoad16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicLoad32U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicStore,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicStore,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicStore8,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicStore16,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicStore8,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicStore16,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicStore32,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwAdd,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwAdd,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8AddU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16AddU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8AddU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16AddU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32AddU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwSub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwSub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8SubU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16SubU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8SubU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16SubU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32SubU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwAnd,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwAnd,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8AndU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16AndU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8AndU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16AndU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32AndU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwOr,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwOr,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8OrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16OrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8OrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16OrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32OrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwXor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwXor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8XorU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16XorU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8XorU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16XorU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32XorU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwXchg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwXchg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8XchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16XchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8XchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16XchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32XchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmwCmpxchg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmwCmpxchg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw8CmpxchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32AtomicRmw16CmpxchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw8CmpxchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw16CmpxchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64AtomicRmw32CmpxchgU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Store,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Const,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16ExtractLaneS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16ExtractLaneU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtractLaneS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtractLaneU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtractLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtractLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4ExtractLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2ExtractLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2ReplaceLane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16LtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16GtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16LeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16GeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8LtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8GtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8LeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8GeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4LtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4GtU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4LeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4GeU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2LtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2GtS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2LeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2GeS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Lt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Gt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Le,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Ge,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Eq,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Ne,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Lt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Gt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Le,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Ge,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Not,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128And,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128AndNot,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Or,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Xor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Bitselect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128AnyTrue,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16AllTrue,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Bitmask,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16AddSatS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16AddSatU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16SubSatS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16SubSatU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16MinS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16MinU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16MaxS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16MaxU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Popcnt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8AllTrue,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Bitmask,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8AddSatS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8AddSatU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8SubSatS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8SubSatU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8MinS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8MinU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8MaxS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8MaxU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtAddPairwiseI8x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtAddPairwiseI8x16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4AllTrue,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Bitmask,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4MinS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4MinU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4MaxS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4MaxU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4DotI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtAddPairwiseI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtAddPairwiseI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2AllTrue,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Bitmask,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Shl,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ShrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ShrU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Ceil,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Floor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Trunc,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Nearest,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Ceil,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Floor,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Trunc,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Nearest,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Sqrt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Div,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Min,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Max,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4PMin,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4PMax,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Abs,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Neg,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Sqrt,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Add,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Sub,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Mul,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Div,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Min,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Max,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2PMin,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2PMax,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4TruncSatF32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4TruncSatF32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4ConvertI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4ConvertI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Swizzle,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16Shuffle,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load8Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load16Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load32Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load32Zero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load64Splat,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load64Zero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16NarrowI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16NarrowI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8NarrowI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8NarrowI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtendLowI8x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtendHighI8x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtendLowI8x16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtendHighI8x16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtendLowI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtendHighI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtendLowI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtendHighI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtendLowI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtendHighI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtendLowI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtendHighI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtMulLowI8x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtMulHighI8x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtMulLowI8x16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8ExtMulHighI8x16U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtMulLowI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtMulHighI16x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtMulLowI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4ExtMulHighI16x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtMulLowI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtMulHighI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtMulLowI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2ExtMulHighI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load8x8S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load8x8U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load16x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load16x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load32x2S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load32x2U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load8Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load16Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load32Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Load64Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Store8Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Store16Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Store32Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  V128Store64Lane,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16RoundingAverageU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8RoundingAverageU,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8Q15MulrSatS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4DemoteF64x2Zero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2PromoteLowF32x4,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2ConvertLowI32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2ConvertLowI32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4TruncSatF64x2SZero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4TruncSatF64x2UZero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16RelaxedSwizzle,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4RelaxedTruncSatF32x4S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4RelaxedTruncSatF32x4U,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4RelaxedTruncSatF64x2SZero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4RelaxedTruncSatF64x2UZero,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Fma,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4Fms,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Fma,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2Fms,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I8x16LaneSelect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8LaneSelect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4LaneSelect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I64x2LaneSelect,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4RelaxedMin,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4RelaxedMax,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2RelaxedMin,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F64x2RelaxedMax,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8RelaxedQ15mulrS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I16x8DotI8x16I7x16S,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  I32x4DotI8x16I7x16AddS,
#endif
#if defined(WASMER_COMPILER_ENABLED)
  F32x4RelaxedDotBf16x8AddF32x4,
#endif
} wasmer_parser_operator_t;
#endif

#if defined(WASMER_WASI_ENABLED)
typedef struct wasi_config_t wasi_config_t;
#endif

#if defined(WASMER_WASI_ENABLED)
typedef struct wasi_env_t wasi_env_t;
#endif

typedef struct wasmer_cpu_features_t wasmer_cpu_features_t;

typedef struct wasmer_features_t wasmer_features_t;

typedef struct wasmer_metering_t wasmer_metering_t;

typedef struct wasmer_middleware_t wasmer_middleware_t;

#if defined(WASMER_WASI_ENABLED)
typedef struct wasmer_named_extern_t wasmer_named_extern_t;
#endif

typedef struct wasmer_target_t wasmer_target_t;

typedef struct wasmer_triple_t wasmer_triple_t;

#if defined(WASMER_WASI_ENABLED)
typedef struct wasi_filesystem_t {
  const char *ptr;
  uintptr_t size;
} wasi_filesystem_t;
#endif

#if defined(WASMER_WASI_ENABLED)
typedef struct wasmer_named_extern_vec_t {
  uintptr_t size;
  struct wasmer_named_extern_t **data;
} wasmer_named_extern_vec_t;
#endif

typedef struct FunctionCEnv {
  void *inner;
} FunctionCEnv;

typedef struct wasmer_funcenv_t {
  struct FunctionCEnv inner;
} wasmer_funcenv_t;

typedef uint64_t (*wasmer_metering_cost_function_t)(enum wasmer_parser_operator_t wasm_operator);

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined(WASMER_WASI_ENABLED)
void wasi_config_arg(struct wasi_config_t *config, const char *arg);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_capture_stderr(struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_capture_stdout(struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_env(struct wasi_config_t *config, const char *key, const char *value);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_inherit_stderr(struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_inherit_stdin(struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_config_inherit_stdout(struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
bool wasi_config_mapdir(struct wasi_config_t *config, const char *alias, const char *dir);
#endif

#if defined(WASMER_WASI_ENABLED)
struct wasi_config_t *wasi_config_new(const char *program_name);
#endif

#if defined(WASMER_WASI_ENABLED)
bool wasi_config_preopen_dir(struct wasi_config_t *config, const char *dir);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_env_delete(struct wasi_env_t *state);
#endif

#if defined(WASMER_WASI_ENABLED)
bool wasi_env_initialize_instance(struct wasi_env_t *wasi_env,
                                  wasm_store_t *store,
                                  wasm_instance_t *instance);
#endif

#if defined(WASMER_WASI_ENABLED)
struct wasi_env_t *wasi_env_new(wasm_store_t *store, struct wasi_config_t *config);
#endif

#if defined(WASMER_WASI_ENABLED)
intptr_t wasi_env_read_stderr(struct wasi_env_t *env, char *buffer, uintptr_t buffer_len);
#endif

#if defined(WASMER_WASI_ENABLED)
intptr_t wasi_env_read_stdout(struct wasi_env_t *env, char *buffer, uintptr_t buffer_len);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_env_set_memory(struct wasi_env_t *_env, const wasm_memory_t *_memory);
#endif

#if defined(WASMER_WASI_ENABLED)
struct wasi_env_t *wasi_env_with_filesystem(struct wasi_config_t *config,
                                            wasm_store_t *store,
                                            const wasm_module_t *module,
                                            const struct wasi_filesystem_t *fs,
                                            wasm_extern_vec_t *imports,
                                            const char *package);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasi_filesystem_delete(struct wasi_filesystem_t *ptr);
#endif

#if defined(WASMER_WASI_ENABLED)
struct wasi_filesystem_t *wasi_filesystem_init_static_memory(const wasm_byte_vec_t *volume_bytes);
#endif

#if defined(WASMER_WASI_ENABLED)
bool wasi_get_imports(const wasm_store_t *_store,
                      struct wasi_env_t *wasi_env,
                      const wasm_module_t *module,
                      wasm_extern_vec_t *imports);
#endif

#if defined(WASMER_WASI_ENABLED)
wasm_func_t *wasi_get_start_function(wasm_instance_t *instance);
#endif

#if defined(WASMER_WASI_ENABLED)
bool wasi_get_unordered_imports(struct wasi_env_t *wasi_env,
                                const wasm_module_t *module,
                                struct wasmer_named_extern_vec_t *imports);
#endif

#if defined(WASMER_WASI_ENABLED)
enum wasi_version_t wasi_get_wasi_version(const wasm_module_t *module);
#endif

void wasm_config_canonicalize_nans(wasm_config_t *config, bool enable);

void wasm_config_push_middleware(wasm_config_t *config, struct wasmer_middleware_t *middleware);

#if defined(WASMER_COMPILER_ENABLED)
void wasm_config_set_compiler(wasm_config_t *config, enum wasmer_compiler_t compiler);
#endif

void wasm_config_set_engine(wasm_config_t *config, enum wasmer_engine_t engine);

void wasm_config_set_features(wasm_config_t *config, struct wasmer_features_t *features);

void wasm_config_set_target(wasm_config_t *config, struct wasmer_target_t *target);

bool wasmer_cpu_features_add(struct wasmer_cpu_features_t *cpu_features,
                             const wasm_name_t *feature);

void wasmer_cpu_features_delete(struct wasmer_cpu_features_t *_cpu_features);

struct wasmer_cpu_features_t *wasmer_cpu_features_new(void);

bool wasmer_features_bulk_memory(struct wasmer_features_t *features, bool enable);

void wasmer_features_delete(struct wasmer_features_t *_features);

bool wasmer_features_memory64(struct wasmer_features_t *features, bool enable);

bool wasmer_features_module_linking(struct wasmer_features_t *features, bool enable);

bool wasmer_features_multi_memory(struct wasmer_features_t *features, bool enable);

bool wasmer_features_multi_value(struct wasmer_features_t *features, bool enable);

struct wasmer_features_t *wasmer_features_new(void);

bool wasmer_features_reference_types(struct wasmer_features_t *features, bool enable);

bool wasmer_features_simd(struct wasmer_features_t *features, bool enable);

bool wasmer_features_tail_call(struct wasmer_features_t *features, bool enable);

bool wasmer_features_threads(struct wasmer_features_t *features, bool enable);

void wasmer_funcenv_delete(struct wasmer_funcenv_t *_funcenv);

struct wasmer_funcenv_t *wasmer_funcenv_new(wasm_store_t *store, void *data);

#if defined(WASMER_COMPILER_ENABLED)
bool wasmer_is_compiler_available(enum wasmer_compiler_t compiler);
#endif

bool wasmer_is_engine_available(enum wasmer_engine_t engine);

bool wasmer_is_headless(void);

int wasmer_last_error_length(void);

int wasmer_last_error_message(char *buffer, int length);

struct wasmer_middleware_t *wasmer_metering_as_middleware(struct wasmer_metering_t *metering);

void wasmer_metering_delete(struct wasmer_metering_t *_metering);

uint64_t wasmer_metering_get_remaining_points(wasm_instance_t *instance);

struct wasmer_metering_t *wasmer_metering_new(uint64_t initial_limit,
                                              wasmer_metering_cost_function_t cost_function);

bool wasmer_metering_points_are_exhausted(wasm_instance_t *instance);

void wasmer_metering_set_remaining_points(wasm_instance_t *instance, uint64_t new_limit);

void wasmer_module_name(const wasm_module_t *module, wasm_name_t *out);

wasm_module_t *wasmer_module_new(wasm_engine_t *engine, const wasm_byte_vec_t *bytes);

bool wasmer_module_set_name(wasm_module_t *module, const wasm_name_t *name);

#if defined(WASMER_WASI_ENABLED)
const wasm_name_t *wasmer_named_extern_module(const struct wasmer_named_extern_t *named_extern);
#endif

#if defined(WASMER_WASI_ENABLED)
const wasm_name_t *wasmer_named_extern_name(const struct wasmer_named_extern_t *named_extern);
#endif

#if defined(WASMER_WASI_ENABLED)
const wasm_extern_t *wasmer_named_extern_unwrap(const struct wasmer_named_extern_t *named_extern);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasmer_named_extern_vec_copy(struct wasmer_named_extern_vec_t *out_ptr,
                                  const struct wasmer_named_extern_vec_t *in_ptr);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasmer_named_extern_vec_delete(struct wasmer_named_extern_vec_t *ptr);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasmer_named_extern_vec_new(struct wasmer_named_extern_vec_t *out,
                                 uintptr_t length,
                                 struct wasmer_named_extern_t *const *init);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasmer_named_extern_vec_new_empty(struct wasmer_named_extern_vec_t *out);
#endif

#if defined(WASMER_WASI_ENABLED)
void wasmer_named_extern_vec_new_uninitialized(struct wasmer_named_extern_vec_t *out,
                                               uintptr_t length);
#endif

void wasmer_setup_tracing(int verbosity_level, int use_color);

void wasmer_target_delete(struct wasmer_target_t *_target);

struct wasmer_target_t *wasmer_target_new(struct wasmer_triple_t *triple,
                                          struct wasmer_cpu_features_t *cpu_features);

void wasmer_triple_delete(struct wasmer_triple_t *_triple);

struct wasmer_triple_t *wasmer_triple_new(const wasm_name_t *triple);

struct wasmer_triple_t *wasmer_triple_new_from_host(void);

const char *wasmer_version(void);

uint8_t wasmer_version_major(void);

uint8_t wasmer_version_minor(void);

uint8_t wasmer_version_patch(void);

const char *wasmer_version_pre(void);

void wat2wasm(const wasm_byte_vec_t *wat, wasm_byte_vec_t *out);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* WASMER_H */
