"use strict";
/**
 * @author jdiaz5513
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Int64List = void 0;
const tslib_1 = require("tslib");
const debug_1 = tslib_1.__importDefault(require("debug"));
const list_element_size_1 = require("../list-element-size");
const list_1 = require("./list");
const pointer_1 = require("./pointer");
const trace = debug_1.default("capnp:list:composite");
trace("load");
class Int64List extends list_1.List {
    get(index) {
        const c = pointer_1.getContent(this);
        return c.segment.getInt64(c.byteOffset + index * 8);
    }
    set(index, value) {
        const c = pointer_1.getContent(this);
        c.segment.setInt64(c.byteOffset + index * 8, value);
    }
    toString() {
        return `Int64_${super.toString()}`;
    }
}
exports.Int64List = Int64List;
Int64List._capnp = {
    displayName: "List<Int64>",
    size: list_element_size_1.ListElementSize.BYTE_8,
};
//# sourceMappingURL=int64-list.js.map