"use strict";
exports.fy = void 0;
var _index = require("./fy/_lib/formatDistance.cjs");
var _index2 = require("./fy/_lib/formatLong.cjs");
var _index3 = require("./fy/_lib/formatRelative.cjs");
var _index4 = require("./fy/_lib/localize.cjs");
var _index5 = require("./fy/_lib/match.cjs");

/**
 * @category Locales
 * @summary Western Frisian locale (Netherlands).
 * @language West Frisian
 * @iso-639-2 fry
 * @author Damon Asberg [@damon02](https://github.com/damon02)
 */
const fy = (exports.fy = {
  code: "fy",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
