"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._stderr = exports._ignoreErrors = exports.Console = void 0;
Object.defineProperty(exports, "_stderrErrorHandler", {
  enumerable: true,
  get: function () {
    return _noop.default;
  }
});
exports._stdout = void 0;
Object.defineProperty(exports, "_stdoutErrorHandler", {
  enumerable: true,
  get: function () {
    return _noop.default;
  }
});
Object.defineProperty(exports, "_times", {
  enumerable: true,
  get: function () {
    return _proxy.default;
  }
});
exports.clear = exports.assert = void 0;
exports.context = context;
exports.warn = exports.trace = exports.timeStamp = exports.timeLog = exports.timeEnd = exports.time = exports.table = exports.profileEnd = exports.profile = exports.log = exports.info = exports.groupEnd = exports.groupCollapsed = exports.group = exports.error = exports.dirxml = exports.dir = exports.default = exports.debug = exports.createTask = exports.countReset = exports.count = void 0;
var _nodeStream = require("node:stream");
var _proxy = _interopRequireDefault(require("../../mock/proxy.cjs"));
var _noop = _interopRequireDefault(require("../../mock/noop.cjs"));
var _utils = require("../../_internal/utils.cjs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const _console = globalThis.console;
const _ignoreErrors = exports._ignoreErrors = true;
const _stderr = exports._stderr = new _nodeStream.Writable();
const _stdout = exports._stdout = new _nodeStream.Writable();
const log = exports.log = _console?.log ?? _noop.default;
const info = exports.info = _console?.info ?? log;
const trace = exports.trace = _console?.trace ?? info;
const debug = exports.debug = _console?.debug ?? log;
const table = exports.table = _console?.table ?? log;
const error = exports.error = _console?.error ?? log;
const warn = exports.warn = _console?.warn ?? error;
const createTask = exports.createTask = _console?.createTask ?? (0, _utils.notImplemented)("console.createTask");
const assert = exports.assert = (0, _utils.notImplemented)("console.assert");
const clear = exports.clear = _console?.clear ?? _noop.default;
const count = exports.count = _console?.count ?? _noop.default;
const countReset = exports.countReset = _console?.countReset ?? _noop.default;
const dir = exports.dir = _console?.dir ?? _noop.default;
const dirxml = exports.dirxml = _console?.dirxml ?? _noop.default;
const group = exports.group = _console?.group ?? _noop.default;
const groupEnd = exports.groupEnd = _console?.groupEnd ?? _noop.default;
const groupCollapsed = exports.groupCollapsed = _console?.groupCollapsed ?? _noop.default;
const profile = exports.profile = _console?.profile ?? _noop.default;
const profileEnd = exports.profileEnd = _console?.profileEnd ?? _noop.default;
const time = exports.time = _console?.time ?? _noop.default;
const timeEnd = exports.timeEnd = _console?.timeEnd ?? _noop.default;
const timeLog = exports.timeLog = _console?.timeLog ?? _noop.default;
const timeStamp = exports.timeStamp = _console?.timeStamp ?? _noop.default;
const Console = exports.Console = _console?.Console ?? _proxy.default.__createMock__("console.Console");
function context() {
  return _console;
}
module.exports = {
  assert,
  clear,
  Console,
  count,
  countReset,
  debug,
  dir,
  dirxml,
  error,
  group,
  groupEnd,
  groupCollapsed,
  info,
  log,
  profile,
  profileEnd,
  table,
  time,
  timeEnd,
  timeLog,
  timeStamp,
  trace,
  warn
};