"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForDebugger = exports.url = exports.open = exports.default = exports.console = exports.close = exports.Session = exports.Network = void 0;
var _noop = _interopRequireDefault(require("../../mock/noop.cjs"));
var _proxy = _interopRequireDefault(require("../../mock/proxy.cjs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const close = exports.close = _noop.default;
const console = exports.console = _proxy.default.__createMock__("inspector.console");
const open = () => ({
  __unenv__: true,
  [Symbol.dispose]() {
    return Promise.resolve();
  }
});
exports.open = open;
const url = () => void 0;
exports.url = url;
const waitForDebugger = exports.waitForDebugger = _noop.default;
const Session = exports.Session = _proxy.default.__createMock__("inspector.Session");
const Network = exports.Network = _proxy.default.__createMock__("inspector.Network");
module.exports = {
  Session,
  close,
  console,
  open,
  url,
  waitForDebugger,
  Network
};