"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  monitorEventLoopDelay: true,
  createHistogram: true,
  constants: true
};
Object.defineProperty(exports, "constants", {
  enumerable: true,
  get: function () {
    return _constants.constants;
  }
});
exports.monitorEventLoopDelay = exports.default = exports.createHistogram = void 0;
var _histogram = require("./internal/histogram.cjs");
var _constants = require("./internal/constants.cjs");
var _performance = require("./internal/performance.cjs");
Object.keys(_performance).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _performance[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _performance[key];
    }
  });
});
const monitorEventLoopDelay = function (_options) {
  return new _histogram.IntervalHistogram();
};
exports.monitorEventLoopDelay = monitorEventLoopDelay;
const createHistogram = function (_options) {
  return new _histogram.RecordableHistogram();
};
exports.createHistogram = createHistogram;
module.exports = {
  Performance: _performance.Performance,
  PerformanceEntry: _performance.PerformanceEntry,
  PerformanceMark: _performance.PerformanceMark,
  PerformanceMeasure: _performance.PerformanceMeasure,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceObserverEntryList: _performance.PerformanceObserverEntryList,
  PerformanceObserver: _performance.PerformanceObserver,
  // @ts-expect-error TODO: resolve type-mismatch between web and node PerformanceObserverEntryList
  PerformanceResourceTiming: _performance.PerformanceResourceTiming,
  constants: _constants.constants,
  createHistogram,
  monitorEventLoopDelay,
  performance: _performance.performance
};