import { BroadcastChannel } from "./internal/broadcast-channel.mjs";
import { MessageChannel } from "./internal/message-channel.mjs";
import { MessagePort } from "./internal/message-port.mjs";
import { Worker } from "./internal/worker.mjs";
import { notImplemented } from "../../_internal/utils.mjs";
export { BroadcastChannel } from "./internal/broadcast-channel.mjs";
export { MessageChannel } from "./internal/message-channel.mjs";
export { MessagePort } from "./internal/message-port.mjs";
export { Worker } from "./internal/worker.mjs";
const _environmentData = /* @__PURE__ */ new Map();
export const getEnvironmentData = function getEnvironmentData2(key) {
  return _environmentData.get(key);
};
export const setEnvironmentData = function setEnvironmentData2(key, value) {
  _environmentData.set(key, value);
};
export const isMainThread = true;
export const isMarkedAsUntransferable = () => false;
export const markAsUntransferable = function markAsUntransferable2(value) {
};
export const markAsUncloneable = () => {
};
export const moveMessagePortToContext = () => new MessagePort();
export const parentPort = null;
export const receiveMessageOnPort = () => void 0;
export const SHARE_ENV = Symbol.for(
  "nodejs.worker_threads.SHARE_ENV"
);
export const resourceLimits = {};
export const threadId = 0;
export const workerData = null;
export const postMessageToThread = notImplemented(
  "worker_threads.postMessageToThread"
);
export default {
  BroadcastChannel,
  MessageChannel,
  MessagePort,
  Worker,
  SHARE_ENV,
  getEnvironmentData,
  isMainThread,
  isMarkedAsUntransferable,
  markAsUntransferable,
  markAsUncloneable,
  moveMessagePortToContext,
  parentPort,
  receiveMessageOnPort,
  resourceLimits,
  setEnvironmentData,
  postMessageToThread,
  threadId,
  workerData
};
